
///////////////////////////////////////////////////////////

/*
var gPersonBaseObstructions = new Array();

function AddPersonBaseObstruction(person) {
  if (!DoesPersonExist(person))
    return false;

  var base = GetPersonSpriteset(person).base;
  gPersonBaseObstructions.push(new PersonBaseObstruction(person, base.x1, base.y1, base.x2, base.y2));
  return true;
}

function IsPersonBaseObstructionAdded(person) {
  return (GetPersonBaseObstructionIndex(person) >= 0)
}

function GetPersonBaseObstructionIndex(person) {
  var index = -1;
  for (var i = 0; i < gPersonBaseObstructions.length; ++i) {
    if (gPersonBaseObstructions[i].person == person) {
      index = i;
      break;
    }
  }
  return index;
}

function PersonBaseObstruction(person, x1, y1, x2, y2) {
  this.person = person;
  this.x1 = x1;
  this.y1 = y1;
  this.x2 = x2;
  this.y2 = y2;
  this.width =  x2 - x1;
  this.height = y2 - y1;
}

function ClearPersonBaseObstruction(person) {
  var index = GetPersonBaseObstructionIndex(person);
  if (index > -1)
    gPersonBaseObstructions = gPersonBaseObstructions.splice(index, 1);
  return (index > -1);
}

function ClearAllPersonBaseObstructions() {
  gPersonBaseObstructions = new Array();
}
*/

///////////////////////////////////////////////////////////

function GetPersonBaseObstructionX1(person) {
  return GetPersonBase(person).x1;
}

function GetPersonBaseObstructionY1(person) {
  return GetPersonBase(person).y1;
}

function GetPersonBaseObstructionX2(person) {
  return GetPersonBase(person).x2;
}

function GetPersonBaseObstructionY2(person) {
  return GetPersonBase(person).y2;
}

function GetPersonBaseObstructionWidth(person) {
  var base = GetPersonBase(person);
  return (Math.max(base.x2, base.x1) - Math.min(base.x2, base.x1));
}

function GetPersonBaseObstructionHeight(person) {
  var base = GetPersonBase(person);
  return (Math.max(base.y2, base.y1) - Math.min(base.y2, base.y1));
}

///////////////////////////////////////////////////////////


function GetPersonBaseObstructionLeftX(person) {
  return GetPersonX(person) - Math.round(GetPersonBaseObstructionWidth(person) / 2);
}

function GetPersonBaseObstructionRightX(person) {
  return GetPersonX(person) + Math.round(GetPersonBaseObstructionWidth(person) / 2);
}

function GetPersonBaseObstructionTopY(person) {
  return GetPersonY(person) - Math.round(GetPersonBaseObstructionHeight(person) / 2);
}

function GetPersonBaseObstructionBottomY(person) {
  return GetPersonY(person) + Math.round(GetPersonBaseObstructionHeight(person) / 2);
}


///////////////////////////////////////////////////////////

function Collision(person1, person2, collision_base_x, collision_base_y) {
  this.person1 = person1;
  this.person2 = person2;
  this.collision_base_x = collision_base_x;
  this.collision_base_y = collision_base_y;
}

///////////////////////////////////////////////////////////

function GetAllCollisions(person_list) {
  var collision_list = new Array();

  if (typeof(person_list) != "object")
    person_list = GetPersonList();

  for (var i = 0; i < person_list.length; ++i) {
    collision_list = collision_list.concat(GetPersonCollisions(person_list[i]));
  }
  
  return collision_list;
}

///////////////////////////////////////////////////////////

function GetPersonCollisions(person1, distance, person_list) {

  var collision_list = new Array();

  if (typeof(person_list) != "object")
    person_list = GetPersonList();

  if (!DoesPersonExist(person1)) {
    return collision_list;
  }
  
  if (typeof(distance) != "number")
    distance = 1;

  var person1_left_x   = GetPersonBaseObstructionLeftX(person1)   - Math.round(distance / 2);
  var person1_top_y    = GetPersonBaseObstructionTopY(person1)    - Math.round(distance / 2);
  var person1_right_x  = GetPersonBaseObstructionRightX(person1)  + Math.round(distance / 2);
  var person1_bottom_y = GetPersonBaseObstructionBottomY(person1) + Math.round(distance / 2);

  var person1_x_points_to_test = new Array(person1_left_x, person1_right_x, person1_right_x,  person1_left_x);
  var person1_y_points_to_test = new Array(person1_top_y,  person1_top_y,   person1_bottom_y, person1_bottom_y);
  
  for (var j = 0; j < person_list.length; j++) {

    var person2 = person_list[j];

    if (person1 == person2) {
      continue;
    }

    if (!DoesPersonExist(person2)) {
      continue;
    }

    var person2_left_x   = GetPersonBaseObstructionLeftX(person2);
    var person2_top_y    = GetPersonBaseObstructionTopY(person2);
    var person2_right_x  = GetPersonBaseObstructionRightX(person2);
    var person2_bottom_y = GetPersonBaseObstructionBottomY(person2);

    var person2_x_points_to_test = new Array(person2_left_x, person2_right_x, person2_right_x,  person2_left_x);
    var person2_y_points_to_test = new Array(person2_top_y,  person2_top_y,   person2_bottom_y, person2_bottom_y);

    for (var i = 0; (i < person2_x_points_to_test.length && i < person2_y_points_to_test.length); ++i) {

      if ((person2_x_points_to_test[i] >= person1_left_x && person2_x_points_to_test[i] <= person1_right_x)) {
        if ((person2_y_points_to_test[i] >= person1_top_y  && person2_y_points_to_test[i] <= person1_bottom_y)) {
          collision_list.push(new Collision(person1, person2, person2_x_points_to_test[i], person2_y_points_to_test[i]));
        }
      }

    }
    
  }
  return collision_list;
}

///////////////////////////////////////////////////////////

function DoesPersonExist(person)
{
  var p = GetPersonList();
  for (var i = 0; i < p.length; ++i)
    if (p[i] == person)
      return true;
  return false;
}

///////////////////////////////////////////////////////////

function DrawPersonBase(person, distance, percentage) {

  if (!DoesPersonExist(person)) {
    return false;
  }

  if (typeof(distance) != "number")
    distance = 0;

  if (typeof(percentage) != "number")
    percentage = 0;

  var left_x   = GetPersonBaseObstructionLeftX(person)   - distance;
  var top_y    = GetPersonBaseObstructionTopY(person)    - distance;
  var right_x  = GetPersonBaseObstructionRightX(person)  + distance;
  var bottom_y = GetPersonBaseObstructionBottomY(person) + distance;
    
  var layer = GetPersonLayer(person);

  Line(MapToScreenX(layer, left_x),  MapToScreenY(layer, top_y),    MapToScreenX(layer, right_x), MapToScreenY(layer, top_y),    CreateColor(255, 0, 255));
  Line(MapToScreenX(layer, left_x),  MapToScreenY(layer, top_y),    MapToScreenX(layer, left_x),  MapToScreenY(layer, bottom_y), CreateColor(255, 0, 255));
  Line(MapToScreenX(layer, left_x),  MapToScreenY(layer, bottom_y), MapToScreenX(layer, right_x), MapToScreenY(layer, bottom_y), CreateColor(255, 0, 255));
  Line(MapToScreenX(layer, right_x), MapToScreenY(layer, top_y),    MapToScreenX(layer, right_x), MapToScreenY(layer, bottom_y), CreateColor(255, 0, 255));

  return true;
}

///////////////////////////////////////////////////////////

function IsPersonObstructedByPerson(person1, person2, distance) {
  return (GetPersonCollisions(person1, distance, [person2]).length > 0);
}

///////////////////////////////////////////////////////////

function IsPersonWithinPersonsObstructionBase(person1, person2, distance) {
  return (!IsPersonObstructedByPerson(person1, person2, distance)
       &&  IsPersonObstructedByPerson(person2, person1, distance));
}

///////////////////////////////////////////////////////////
